/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.animation.CBipedAnimation;
import com.fantasticsource.mctools.betterattributes.BetterAttribute;
import com.fantasticsource.mctools.component.CResourceLocation;
import com.fantasticsource.mctools.controlintercept.ControlEvent;
import com.fantasticsource.mctools.sound.SimpleSound;
import com.fantasticsource.tools.component.CUUID;
import com.fantasticsource.tools.component.Component;
import com.fantasticsource.tools.component.path.CPath;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = new SimpleNetworkWrapper("fantasticlib");
    private static int discriminator = 0;

    public static void init() {
        WRAPPER.registerMessage(PlaySimpleSoundPacketHandler.class, PlaySimpleSoundPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(ControlEventPacketHandler.class, ControlEventPacket.class, discriminator++, Side.SERVER);
        WRAPPER.registerMessage(GenericComponentPacketHandler.class, GenericComponentPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(RemoveEntityImmediatePacketHandler.class, RemoveEntityImmediatePacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(BetterAttributePacketHandler.class, BetterAttributePacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(AddBipedAnimationsPacketHandler.class, AddBipedAnimationsPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(RemoveBipedAnimationPacketHandler.class, RemoveBipedAnimationPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(UpdateBipedAnimationsPacketHandler.class, UpdateBipedAnimationsPacket.class, discriminator++, Side.CLIENT);
    }

    public static class UpdateBipedAnimationsPacketHandler
    implements IMessageHandler<UpdateBipedAnimationsPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(UpdateBipedAnimationsPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                if (mc.field_71441_e == null) {
                    return;
                }
                Entity entity = mc.field_71441_e.func_73045_a(packet.entityID);
                if (entity == null) {
                    return;
                }
                long offsetMillis = System.currentTimeMillis() - packet.serverSystemMillis;
                for (CBipedAnimation animation : packet.animations) {
                    animation.startTime += offsetMillis;
                    animation.setAllStartTimes(animation.startTime);
                    if (animation.pauseTime > -1L) {
                        animation.pauseTime += offsetMillis;
                    }
                    for (CPath.CPathData data : animation.getAllData()) {
                        if (data.pauseTime <= -1L) continue;
                        data.pauseTime += offsetMillis;
                    }
                    if (!CBipedAnimation.removeAnimations(entity, animation.id)) continue;
                    CBipedAnimation.addAnimation(entity, animation);
                }
            });
            return null;
        }
    }

    public static class UpdateBipedAnimationsPacket
    implements IMessage {
        int entityID;
        CBipedAnimation[] animations;
        long serverSystemMillis;

        public UpdateBipedAnimationsPacket() {
        }

        public UpdateBipedAnimationsPacket(Entity entity, CBipedAnimation ... animations) {
            this.entityID = entity.func_145782_y();
            this.animations = animations;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            buf.writeInt(this.animations.length);
            for (CBipedAnimation animation : this.animations) {
                animation.write(buf);
            }
            buf.writeLong(System.currentTimeMillis());
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            this.animations = new CBipedAnimation[buf.readInt()];
            for (int i = 0; i < this.animations.length; ++i) {
                this.animations[i] = new CBipedAnimation().read(buf);
            }
            this.serverSystemMillis = buf.readLong();
        }
    }

    public static class RemoveBipedAnimationPacketHandler
    implements IMessageHandler<RemoveBipedAnimationPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(RemoveBipedAnimationPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                if (mc.field_71441_e == null) {
                    return;
                }
                Entity entity = mc.field_71441_e.func_73045_a(packet.entityID);
                if (entity == null) {
                    return;
                }
                CBipedAnimation.removeAnimations(entity, packet.animationID);
            });
            return null;
        }
    }

    public static class RemoveBipedAnimationPacket
    implements IMessage {
        int entityID;
        UUID animationID;

        public RemoveBipedAnimationPacket() {
        }

        public RemoveBipedAnimationPacket(Entity entity, CBipedAnimation animation) {
            this.entityID = entity.func_145782_y();
            this.animationID = animation.id;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            new CUUID().set(this.animationID).write(buf);
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            this.animationID = new CUUID().read((ByteBuf)buf).value;
        }
    }

    public static class AddBipedAnimationsPacketHandler
    implements IMessageHandler<AddBipedAnimationsPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(AddBipedAnimationsPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                if (mc.field_71441_e == null) {
                    return;
                }
                Entity entity = mc.field_71441_e.func_73045_a(packet.entityID);
                if (entity == null) {
                    return;
                }
                long offsetMillis = System.currentTimeMillis() - packet.serverSystemMillis;
                for (CBipedAnimation animation : packet.animations) {
                    animation.startTime += offsetMillis;
                    animation.setAllStartTimes(animation.startTime);
                    if (animation.pauseTime > -1L) {
                        animation.pauseTime += offsetMillis;
                    }
                    for (CPath.CPathData data : animation.getAllData()) {
                        if (data.pauseTime <= -1L) continue;
                        data.pauseTime += offsetMillis;
                    }
                    CBipedAnimation.addAnimation(entity, animation);
                }
            });
            return null;
        }
    }

    public static class AddBipedAnimationsPacket
    implements IMessage {
        int entityID;
        CBipedAnimation[] animations;
        long serverSystemMillis;

        public AddBipedAnimationsPacket() {
        }

        public AddBipedAnimationsPacket(Entity entity, CBipedAnimation ... animations) {
            this.entityID = entity.func_145782_y();
            this.animations = animations;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            buf.writeInt(this.animations.length);
            for (CBipedAnimation animation : this.animations) {
                animation.write(buf);
            }
            buf.writeLong(System.currentTimeMillis());
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            this.animations = new CBipedAnimation[buf.readInt()];
            for (int i = 0; i < this.animations.length; ++i) {
                this.animations[i] = new CBipedAnimation().read(buf);
            }
            this.serverSystemMillis = buf.readLong();
        }
    }

    public static class BetterAttributePacketHandler
    implements IMessageHandler<BetterAttributePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(BetterAttributePacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                if (mc.field_71441_e == null) {
                    return;
                }
                Entity entity = mc.field_71441_e.func_73045_a(packet.entityID);
                if (entity == null) {
                    return;
                }
                BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(packet.attributeName);
                if (attribute == null) {
                    return;
                }
                NBTTagCompound compound = MCTools.getOrGenerateSubCompound(entity.getEntityData(), "fantasticlib");
                attribute.setBaseAmount(entity, packet.base);
                MCTools.getOrGenerateSubCompound(compound, "attributes").func_74780_a(attribute.name, packet.total);
                attribute.setCurrentAmount(entity, packet.current);
            });
            return null;
        }
    }

    public static class BetterAttributePacket
    implements IMessage {
        int entityID;
        String attributeName;
        double base;
        double total;
        double current;

        public BetterAttributePacket() {
        }

        public BetterAttributePacket(Entity entity, BetterAttribute attribute) {
            this.entityID = entity.func_145782_y();
            this.attributeName = attribute.name;
            this.base = attribute.getBaseAmount(entity);
            this.total = attribute.getTotalAmount(entity);
            this.current = attribute.getCurrentAmount(entity);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.entityID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.attributeName);
            buf.writeDouble(this.base);
            buf.writeDouble(this.total);
            buf.writeDouble(this.current);
        }

        public void fromBytes(ByteBuf buf) {
            this.entityID = buf.readInt();
            this.attributeName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.base = buf.readDouble();
            this.total = buf.readDouble();
            this.current = buf.readDouble();
        }
    }

    public static class RemoveEntityImmediatePacketHandler
    implements IMessageHandler<RemoveEntityImmediatePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(RemoveEntityImmediatePacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                if (mc.field_71441_e == null) {
                    return;
                }
                Entity entity = mc.field_71441_e.func_73045_a(packet.id);
                if (entity == null) {
                    return;
                }
                MCTools.removeEntityImmediate(entity);
                mc.field_71441_e.func_73022_a();
            });
            return null;
        }
    }

    public static class RemoveEntityImmediatePacket
    implements IMessage {
        public int id;

        public RemoveEntityImmediatePacket() {
        }

        public RemoveEntityImmediatePacket(Entity entity) {
            this.id = entity.func_145782_y();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }
    }

    public static class GenericComponentPacketHandler
    implements IMessageHandler<GenericComponentPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GenericComponentPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> packet.component.onClientSync());
            return null;
        }
    }

    public static class GenericComponentPacket
    implements IMessage {
        public Component component;

        public GenericComponentPacket() {
        }

        public GenericComponentPacket(Component component) {
            this.component = component;
        }

        public void toBytes(ByteBuf buf) {
            Component.writeMarked(buf, this.component);
        }

        public void fromBytes(ByteBuf buf) {
            this.component = Component.readMarked(buf);
        }
    }

    public static class ControlEventPacketHandler
    implements IMessageHandler<ControlEventPacket, IMessage> {
        public IMessage onMessage(ControlEventPacket packet, MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            server.func_152344_a(() -> MinecraftForge.EVENT_BUS.post((Event)packet.event.setPlayer(ctx.getServerHandler().field_147369_b)));
            return null;
        }
    }

    public static class ControlEventPacket
    implements IMessage {
        public ControlEvent event;

        public ControlEventPacket() {
        }

        public ControlEventPacket(ControlEvent event) {
            this.event = event;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.event.name);
            buf.writeBoolean(this.event.state);
            buf.writeBoolean(this.event.lastState != null);
            if (this.event.lastState != null) {
                buf.writeBoolean(this.event.lastState.booleanValue());
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.event.identifier);
        }

        public void fromBytes(ByteBuf buf) {
            this.event = new ControlEvent(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readBoolean(), buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null, ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public static class PlaySimpleSoundPacketHandler
    implements IMessageHandler<PlaySimpleSoundPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PlaySimpleSoundPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                SimpleSound simpleSound = null;
                if (packet.followingID != null) {
                    Entity following = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.followingID.intValue());
                    if (following != null) {
                        simpleSound = new SimpleSound(packet.rl.value, packet.soundCategory, following);
                    }
                } else {
                    simpleSound = packet.x != null ? new SimpleSound(packet.rl.value, packet.soundCategory, packet.x.floatValue(), packet.y.floatValue(), packet.z.floatValue()) : new SimpleSound(packet.rl.value, packet.soundCategory);
                }
                if (simpleSound != null) {
                    simpleSound.attenuationType = packet.attenuationType == 0 ? ISound.AttenuationType.NONE : ISound.AttenuationType.LINEAR;
                    simpleSound.volume = packet.volume;
                    simpleSound.pitch = packet.pitch;
                    mc.func_147118_V().func_147682_a((ISound)simpleSound);
                }
            });
            return null;
        }
    }

    public static class PlaySimpleSoundPacket
    implements IMessage {
        public Integer followingID;
        public Float x;
        public Float y;
        public Float z;
        public CResourceLocation rl = new CResourceLocation();
        public int attenuationType;
        public float volume;
        public float pitch;
        public SoundCategory soundCategory;

        public PlaySimpleSoundPacket() {
        }

        public PlaySimpleSoundPacket(ResourceLocation rl) {
            this(rl, null);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, Entity following) {
            this(rl, following, 2, 1.0f, 1.0f);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, Entity following, int attenuationType, float volume, float pitch) {
            this(rl, following, attenuationType, volume, pitch, SoundCategory.MASTER);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, Entity following, int attenuationType, float volume, float pitch, SoundCategory soundCategory) {
            this.x = null;
            this.y = null;
            this.z = null;
            this.rl.set(rl);
            this.followingID = following == null ? null : Integer.valueOf(following.func_145782_y());
            this.attenuationType = attenuationType;
            this.volume = volume;
            this.pitch = pitch;
            this.soundCategory = soundCategory;
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, float x, float y, float z) {
            this(rl, x, y, z, 2, 1.0f, 1.0f);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, float x, float y, float z, int attenuationType, float volume, float pitch) {
            this(rl, x, y, z, attenuationType, volume, pitch, SoundCategory.MASTER);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, float x, float y, float z, int attenuationType, float volume, float pitch, SoundCategory soundCategory) {
            this.followingID = null;
            this.rl.set(rl);
            this.x = Float.valueOf(x);
            this.y = Float.valueOf(y);
            this.z = Float.valueOf(z);
            this.attenuationType = attenuationType;
            this.volume = volume;
            this.pitch = pitch;
            this.soundCategory = soundCategory;
        }

        public void toBytes(ByteBuf buf) {
            this.rl.write(buf);
            buf.writeBoolean(this.followingID != null);
            if (this.followingID != null) {
                buf.writeInt(this.followingID.intValue());
            }
            buf.writeBoolean(this.x != null);
            if (this.x != null) {
                buf.writeFloat(this.x.floatValue());
                buf.writeFloat(this.y.floatValue());
                buf.writeFloat(this.z.floatValue());
            }
            buf.writeInt(this.attenuationType);
            buf.writeFloat(this.volume);
            buf.writeFloat(this.pitch);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundCategory.func_187948_a());
        }

        public void fromBytes(ByteBuf buf) {
            this.rl.read(buf);
            if (buf.readBoolean()) {
                this.followingID = buf.readInt();
            }
            if (buf.readBoolean()) {
                this.x = Float.valueOf(buf.readFloat());
                this.y = Float.valueOf(buf.readFloat());
                this.z = Float.valueOf(buf.readFloat());
            }
            this.attenuationType = buf.readInt();
            this.volume = buf.readFloat();
            this.pitch = buf.readFloat();
            this.soundCategory = SoundCategory.func_187950_a((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }
}

